<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HumanResources extends Model 
{

    protected $table = 'hr';
    public $timestamps = true;
    protected $fillable = array('employee_number', 'salary', 'position', 'jobtitle', 'supervisor', 'hire_date', 'termination_date', 'hourly_rate', 'department', 'user_id', 'employment_status', 'employment_roles');
    protected $visible = array('employee_number', 'salary', 'position', 'jobtitle', 'supervisor', 'hire_date', 'termination_date', 'hourly_rate', 'department', 'user_id', 'employment_status', 'employment_roles');

    public function employee()
    {
        return $this->belongsTo('App\Models\User', 'id', 'user_id');
    }

}